"use strict";
// File: index.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// Load environment variables with multiple path fallbacks
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
// Try multiple paths for .env file - prioritize root .env file
const envPaths = [
    path_1.default.resolve(process.cwd(), ".env"), // Production/Development root .env (PRIORITY)
    path_1.default.resolve(__dirname, "../.env"), // Development relative path
    path_1.default.resolve(__dirname, ".env"), // Fallback (same directory)
    path_1.default.resolve(process.cwd(), "../.env"), // Another fallback
];
let envLoaded = false;
for (const envPath of envPaths) {
    if (fs_1.default.existsSync(envPath)) {
        require("dotenv").config({ path: envPath });
        console.log(`\x1b[32mEnvironment loaded from: ${envPath}\x1b[0m`);
        envLoaded = true;
        break;
    }
}
if (!envLoaded) {
    console.warn(`\x1b[33mWarning: No .env file found. Tried paths: ${envPaths.join(", ")}\x1b[0m`);
    // Try to load from process environment as fallback
    require("dotenv").config();
}
require("./module-alias-setup");
const src_1 = require("./src");
const logger_1 = __importDefault(require("./src/utils/logger"));
const port = process.env.NEXT_PUBLIC_BACKEND_PORT || 4000;
const startApp = async () => {
    try {
        const app = new src_1.MashServer();
        app.listen(Number(port), () => {
            console.log(`\x1b[36mMain Thread: Server running on port ${port}...\x1b[0m`);
        });
    }
    catch (error) {
        (0, logger_1.default)("error", "app", __filename, `Failed to initialize app: ${error.message}`);
        process.exit(1);
    }
};
startApp();
