"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
class binaryDuration extends sequelize_1.Model {
    /**
     * Initialize model
     */
    static initModel(sequelize) {
        return binaryDuration.init({
            id: {
                type: sequelize_1.DataTypes.UUID,
                defaultValue: sequelize_1.DataTypes.UUIDV4,
                primaryKey: true,
                allowNull: false,
            },
            duration: {
                type: sequelize_1.DataTypes.INTEGER,
                allowNull: false,
                validate: {
                    isInt: { msg: "duration: must be an integer (minutes)" },
                    min: { args: [1], msg: "duration: must be at least 1 minute" },
                },
                comment: "Duration in minutes for binary option expiry",
            },
            profitPercentage: {
                type: sequelize_1.DataTypes.DOUBLE,
                allowNull: false,
                validate: {
                    isNumeric: {
                        msg: "profitPercentage: must be a number",
                    },
                    min: { args: [0], msg: "profitPercentage: must be non-negative" },
                },
                comment: "Profit percentage offered for this duration",
            },
            status: {
                type: sequelize_1.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: true,
                validate: {
                    isBoolean: { msg: "status: must be a boolean" },
                },
                comment: "Whether this duration is active and available for trading",
            },
        }, {
            sequelize,
            modelName: "binaryDuration",
            tableName: "binary_duration",
            timestamps: true,
            paranoid: true,
            indexes: [
                {
                    name: "binaryDuration_pkey",
                    unique: true,
                    fields: [{ name: "id" }],
                },
                {
                    name: "binaryDuration_duration_idx",
                    fields: [{ name: "duration" }],
                },
            ],
        });
    }
}
exports.default = binaryDuration;
