"use strict";
// /server/api/mlm/referral-conditions/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const constants_1 = require("@b/utils/constants");
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "Lists all MLM Referral Conditions with pagination and optional filtering",
    operationId: "listMlmReferralConditions",
    tags: ["Admin", "MLM", "Referral Conditions"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "List of MLM Referral Conditions with pagination information",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            data: {
                                type: "array",
                                items: {
                                    type: "object",
                                    properties: utils_1.mlmReferralConditionSchema,
                                },
                            },
                            pagination: constants_1.paginationSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("MLM Referral Conditions"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "view.affiliate.condition",
};
exports.default = async (data) => {
    const { query } = data;
    // Call the generic fetch function
    return (0, query_1.getFiltered)({
        model: db_1.models.mlmReferralCondition,
        query,
        sortField: query.sortField || "id",
        timestamps: false,
    });
};
