"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const error_1 = require("@b/utils/error");
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Retrieves a list of ecommerce categories",
    description: "This endpoint retrieves active ecommerce categories for selection in the UI. Only categories with status true are returned.",
    operationId: "getEcommerceCategoryOptions",
    tags: ["Ecommerce", "Category"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Ecommerce categories retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {
                                value: { type: "string" },
                                label: { type: "string" },
                            },
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("EcommerceCategory"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw (0, error_1.createError)(401, "Unauthorized");
    try {
        const categories = await db_1.models.ecommerceCategory.findAll({
            where: { status: true },
            attributes: ["id", "name"],
            order: [["name", "ASC"]],
        });
        const formatted = categories.map((category) => ({
            value: category.id,
            label: category.name,
        }));
        return formatted;
    }
    catch (error) {
        throw (0, error_1.createError)(500, "An error occurred while fetching ecommerce categories");
    }
};
