"use strict";
// /server/api/ecommerce/discounts/delete.del.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk deletes e-commerce discounts by IDs",
    operationId: "bulkDeleteEcommerceDiscounts",
    tags: ["Admin", "Ecommerce", "Discounts"],
    parameters: (0, query_1.commonBulkDeleteParams)("E-commerce Discounts"),
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            items: { type: "string" },
                            description: "Array of e-commerce discount IDs to delete",
                        },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: (0, query_1.commonBulkDeleteResponses)("E-commerce Discounts"),
    requiresAuth: true,
    permission: "delete.ecommerce.discount",
};
exports.default = async (data) => {
    const { body, query } = data;
    const { ids } = body;
    return (0, query_1.handleBulkDelete)({
        model: "ecommerceDiscount",
        ids,
        query,
    });
};
