"use strict";
// /api/admin/ecommerce/products/store.post.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Stores a new E-commerce Product",
    operationId: "storeEcommerceProduct",
    tags: ["Admin", "Ecommerce Products"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: utils_1.ecommerceProductUpdateSchema,
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.ecommerceProductStoreSchema, "E-commerce Product"),
    requiresAuth: true,
    permission: "create.ecommerce.product",
};
exports.default = async (data) => {
    const { body } = data;
    const { name, description, shortDescription, type, price, categoryId, inventoryQuantity, filePath, status, image, currency, walletType, } = body;
    // Validate required fields
    if (!categoryId) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Category ID is required",
        });
    }
    // Check if category exists and is active
    const category = await db_1.models.ecommerceCategory.findOne({
        where: { id: categoryId, status: true },
    });
    if (!category) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Invalid category ID or category is inactive",
        });
    }
    const existingProduct = await db_1.models.ecommerceProduct.findOne({
        where: { name },
    });
    if (existingProduct) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Product with this name already exists",
        });
    }
    return await (0, query_1.storeRecord)({
        model: "ecommerceProduct",
        data: {
            name,
            description,
            shortDescription,
            type,
            price,
            categoryId,
            inventoryQuantity,
            filePath,
            status,
            image,
            currency,
            walletType,
        },
    });
};
