"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const error_1 = require("@b/utils/error");
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Retrieves a list of ecommerce products",
    description: "This endpoint retrieves active ecommerce products for selection in the UI. Only products with status true are returned.",
    operationId: "getEcommerceProductOptions",
    tags: ["Ecommerce", "Product"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Ecommerce products retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {
                                id: { type: "string" },
                                name: { type: "string" },
                            },
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("EcommerceProduct"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw (0, error_1.createError)(401, "Unauthorized");
    try {
        const products = await db_1.models.ecommerceProduct.findAll({
            where: { status: true },
        });
        const formatted = products.map((product) => ({
            id: product.id,
            name: `${product.name} - ${product.price} ${product.currency}`,
        }));
        return formatted;
    }
    catch (error) {
        throw (0, error_1.createError)(500, "An error occurred while fetching ecommerce products");
    }
};
