"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "Stores a new E-commerce Shipping",
    operationId: "storeEcommerceShipping",
    tags: ["Admin", "Ecommerce Shipping"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: utils_1.ecommerceShippingUpdateSchema,
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.ecommerceShippingStoreSchema, "E-commerce Shipping"),
    requiresAuth: true,
    permission: "create.ecommerce.shipping",
};
exports.default = async (data) => {
    const { body } = data;
    return await (0, query_1.storeRecord)({
        model: "ecommerceShipping",
        data: body,
    });
};
