"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const error_1 = require("@b/utils/error");
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Retrieves a list of exchange markets",
    description: "This endpoint retrieves active exchange markets formatted as options for UI selection.",
    operationId: "getExchangeMarketOptions",
    tags: ["Exchange", "Market"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Exchange markets retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {
                                id: { type: "string" },
                                name: { type: "string" },
                            },
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("ExchangeMarket"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw (0, error_1.createError)(401, "Unauthorized");
    try {
        const exchangeMarkets = await db_1.models.exchangeMarket.findAll({
            where: { status: true },
        });
        const formatted = exchangeMarkets.map((market) => ({
            id: market.id,
            name: `${market.currency} / ${market.pair}`,
        }));
        return formatted;
    }
    catch (error) {
        throw (0, error_1.createError)(500, "An error occurred while fetching exchange markets");
    }
};
