"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const constants_1 = require("@b/utils/constants");
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
const query_2 = require("@b/api/(ext)/ecosystem/utils/scylla/query");
exports.metadata = {
    summary: "List all ecosystem orders",
    operationId: "listEcosystemOrders",
    tags: ["Admin", "Ecosystem Orders"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "Ecosystem orders retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            items: {
                                type: "array",
                                items: { type: "object", properties: utils_1.orderSchema },
                            },
                            pagination: {
                                type: "object",
                                properties: {
                                    totalItems: { type: "number" },
                                    currentPage: { type: "number" },
                                    perPage: { type: "number" },
                                    totalPages: { type: "number" },
                                },
                            },
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Ecosystem Orders"),
        500: query_1.serverErrorResponse,
    },
    permission: "view.ecosystem.order",
    requiresAuth: true,
};
const keyspace = process.env.SCYLLA_KEYSPACE || "trading";
exports.default = async (data) => {
    const { query } = data;
    const table = "orders";
    const partitionKeys = ["userId"];
    const result = await (0, query_2.getFiltered)({
        table,
        query,
        filter: query.filter,
        sortField: query.sortField || "createdAt",
        sortOrder: query.sortOrder || "DESC",
        perPage: Number(query.perPage) || 10,
        allowFiltering: true,
        keyspace,
        partitionKeys,
        transformColumns: ["amount", "cost", "fee", "filled", "price", "remaining"],
        nonStringLikeColumns: ["userId"],
    });
    return result;
};
