"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get All FAQ Feedback",
    description: "Retrieves all FAQ feedback records.",
    operationId: "getAllFAQFeedback",
    tags: ["FAQ", "Admin", "Feedback"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Feedback records retrieved successfully",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "object" } },
                },
            },
        },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "view.faq.feedback",
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    try {
        const feedbacks = await db_1.models.faqFeedback.findAll({
            order: [["createdAt", "ASC"]],
        });
        return feedbacks;
    }
    catch (error) {
        console.error("Error fetching FAQ feedback:", error);
        throw (0, error_1.createError)({
            statusCode: 500,
            message: error instanceof Error ? error.message : "Failed to fetch feedback",
        });
    }
};
