"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Bulk Delete FAQs",
    description: "Deletes multiple FAQs in bulk.",
    operationId: "bulkDeleteFAQs",
    tags: ["FAQ", "Admin"],
    requiresAuth: true,
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: { type: "array", items: { type: "string" } },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: {
        200: { description: "FAQs deleted successfully" },
        400: { description: "Bad Request" },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "delete.faq",
};
exports.default = async (data) => {
    const { user, body } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    const { ids } = body;
    if (!Array.isArray(ids) || ids.length === 0) {
        throw (0, error_1.createError)({ statusCode: 400, message: "No FAQ IDs provided" });
    }
    await db_1.models.faq.destroy({ where: { id: ids } });
    return { message: "FAQs deleted successfully" };
};
