"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Bulk Update FAQs",
    description: "Updates multiple FAQs in bulk.",
    operationId: "bulkUpdateFAQs",
    tags: ["FAQ", "Admin"],
    requiresAuth: true,
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: { type: "array", items: { type: "string" } },
                        data: { type: "object", description: "Fields to update" },
                    },
                    required: ["ids", "data"],
                },
            },
        },
    },
    responses: {
        200: { description: "FAQs updated successfully" },
        400: { description: "Bad Request" },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "edit.faq",
};
exports.default = async (data) => {
    const { user, body } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    const { ids, data: updateData } = body;
    if (!Array.isArray(ids) || ids.length === 0) {
        throw (0, error_1.createError)({ statusCode: 400, message: "No FAQ IDs provided" });
    }
    await db_1.models.faq.update(updateData, { where: { id: ids } });
    return { message: "FAQs updated successfully" };
};
