"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Delete FAQs by Page",
    description: "Deletes all FAQs associated with a specific page path.",
    operationId: "deleteFAQsByPage",
    tags: ["FAQ", "Admin"],
    requiresAuth: true,
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        pagePath: {
                            type: "string",
                            description: "Page path to delete FAQs from",
                        },
                    },
                    required: ["pagePath"],
                },
            },
        },
    },
    responses: {
        200: { description: "FAQs deleted successfully for the page" },
        400: { description: "Bad Request" },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "delete.faq",
};
exports.default = async (data) => {
    const { user, body } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    const { pagePath } = body;
    if (!pagePath) {
        throw (0, error_1.createError)({ statusCode: 400, message: "pagePath is required" });
    }
    await db_1.models.faq.destroy({ where: { pagePath } });
    return { message: "FAQs deleted successfully for the page" };
};
