"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Update FAQ Status by Page",
    description: "Enables or disables all FAQs associated with a specific page path.",
    operationId: "updateFAQsStatusByPage",
    tags: ["FAQ", "Admin"],
    requiresAuth: true,
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        pagePath: {
                            type: "string",
                            description: "Page path to update FAQs for",
                        },
                        status: { type: "boolean", description: "New status for FAQs" },
                    },
                    required: ["pagePath", "status"],
                },
            },
        },
    },
    responses: {
        200: { description: "FAQs status updated successfully" },
        400: { description: "Bad Request" },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "edit.faq",
};
exports.default = async (data) => {
    const { user, body } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    const { pagePath, status } = body;
    if (typeof pagePath !== "string") {
        throw (0, error_1.createError)({ statusCode: 400, message: "pagePath is required" });
    }
    await db_1.models.faq.update({ status }, { where: { pagePath } });
    return { message: "FAQs status updated successfully" };
};
