"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get FAQ Questions",
    description: "Retrieves all FAQ questions for admin review.",
    operationId: "getFAQQuestions",
    tags: ["FAQ", "Admin", "Questions"],
    requiresAuth: true,
    responses: {
        200: {
            description: "FAQ questions retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            data: { type: "array", items: { type: "object" } },
                        },
                    },
                },
            },
        },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
    permission: "view.faq.question",
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    try {
        const questions = await db_1.models.faqQuestion.findAll({
            order: [["createdAt", "DESC"]],
        });
        return questions;
    }
    catch (error) {
        console.error("Error fetching FAQ questions:", error);
        throw (0, error_1.createError)({
            statusCode: 500,
            message: error instanceof Error
                ? error.message
                : "Failed to fetch FAQ questions",
        });
    }
};
