"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseMetadata = parseMetadata;
exports.updateForexAccountBalance = updateForexAccountBalance;
exports.updateWalletBalance = updateWalletBalance;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
function parseMetadata(metadataString) {
    let metadata = {};
    if (!metadataString) {
        return metadata;
    }
    try {
        const cleanedString = metadataString.replace(/\\/g, "");
        metadata = JSON.parse(cleanedString) || {};
    }
    catch (e) {
        console.error("Invalid JSON in metadata:", metadataString, e);
        // Return empty object instead of throwing to prevent breaking the flow
    }
    return metadata;
}
async function updateForexAccountBalance(account, cost, refund, t) {
    if (!account || !account.id) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Invalid forex account provided",
        });
    }
    let balance = Number(account.balance) || 0;
    balance = refund ? balance + cost : balance - cost;
    if (balance < 0) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Insufficient forex account balance",
        });
    }
    await db_1.models.forexAccount.update({ balance }, { where: { id: account.id }, transaction: t });
    return db_1.models.forexAccount.findOne({
        where: { id: account.id },
        transaction: t,
    });
}
async function updateWalletBalance(wallet, cost, refund, t) {
    if (!wallet || !wallet.id) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Invalid wallet provided",
        });
    }
    let walletBalance = Number(wallet.balance) || 0;
    walletBalance = refund ? walletBalance + cost : walletBalance - cost;
    if (walletBalance < 0) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Insufficient wallet balance",
        });
    }
    await db_1.models.wallet.update({ balance: walletBalance }, { where: { id: wallet.id }, transaction: t });
    return wallet;
}
