"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get Blockchain Configurations",
    description: "Retrieves all blockchain configurations for ICO admin.",
    operationId: "getBlockchainConfigs",
    tags: ["ICO", "Admin", "Blockchain"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Blockchain configurations retrieved successfully.",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "object" } },
                },
            },
        },
        401: { description: "Unauthorized – Admin privileges required." },
        500: { description: "Internal Server Error" },
    },
    permission: "view.ico.settings",
};
exports.default = async (data) => {
    const { user, query } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({
            statusCode: 401,
            message: "Unauthorized: Admin privileges required.",
        });
    }
    // Check if only status blockchains are requested.
    const statusOnly = (query === null || query === void 0 ? void 0 : query.status) === "true";
    const whereClause = statusOnly ? { status: true } : {};
    const blockchains = await db_1.models.icoBlockchain.findAll({
        where: whereClause,
    });
    return blockchains;
};
