"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Reorder Launch Plans",
    description: "Bulk updates the sortOrder for launch plans. Expects an array of objects with each plan's id and updated sortOrder.",
    operationId: "reorderLaunchPlans",
    tags: ["ICO", "Admin", "LaunchPlans"],
    requestBody: {
        description: "Array of launch plans with new sortOrder values.",
        content: {
            "application/json": {
                schema: {
                    type: "array",
                    items: {
                        type: "object",
                        properties: {
                            id: { type: "string" },
                            sortOrder: { type: "number" },
                        },
                        required: ["id", "sortOrder"],
                    },
                },
            },
        },
    },
    responses: (0, query_1.updateRecordResponses)("Launch Plans Reordered"),
    requiresAuth: true,
    permission: "edit.ico.settings",
};
exports.default = async (data) => {
    const { body } = data;
    if (!Array.isArray(body)) {
        throw (0, error_1.createError)({
            statusCode: 400,
            message: "Request body must be an array of launch plans",
        });
    }
    // Update each plan's sortOrder.
    const updatePromises = body.map((plan) => {
        if (!plan.id || typeof plan.sortOrder !== "number") {
            return Promise.resolve();
        }
        return (0, query_1.updateRecord)("icoLaunchPlan", plan.id, {
            sortOrder: plan.sortOrder,
        });
    });
    await Promise.all(updatePromises);
    return { message: "Launch plans reordered successfully" };
};
