"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get Platform Settings",
    description: "Retrieves the platform settings configuration for ICO admin.",
    operationId: "getPlatformSettings",
    tags: ["ICO", "Admin", "PlatformSettings"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Platform settings retrieved successfully.",
            content: {
                "application/json": {
                    schema: { type: "object" },
                },
            },
        },
        401: { description: "Unauthorized – Admin privileges required." },
        500: { description: "Internal Server Error" },
    },
    permission: "view.ico.settings",
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({
            statusCode: 401,
            message: "Unauthorized: Admin privileges required.",
        });
    }
    const settings = await db_1.models.icoPlatformSettings.findOne();
    if (!settings) {
        throw (0, error_1.createError)({
            statusCode: 404,
            message: "Platform settings not found.",
        });
    }
    return settings;
};
