"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Create Platform Settings",
    description: "Creates a new platform settings configuration for ICO admin.",
    operationId: "createPlatformSettings",
    tags: ["ICO", "Admin", "PlatformSettings"],
    requiresAuth: true,
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        minInvestmentAmount: { type: "number" },
                        maxInvestmentAmount: { type: "number" },
                        platformFeePercentage: { type: "number" },
                        kycRequired: { type: "boolean" },
                        maintenanceMode: { type: "boolean" },
                        allowPublicOfferings: { type: "boolean" },
                        announcementMessage: { type: "string" },
                        announcementActive: { type: "boolean" },
                        // Add additional properties as needed.
                    },
                    required: [
                        "minInvestmentAmount",
                        "maxInvestmentAmount",
                        "platformFeePercentage",
                    ],
                },
            },
        },
    },
    responses: {
        200: { description: "Platform settings created successfully." },
        401: { description: "Unauthorized – Admin privileges required." },
        400: { description: "Bad Request" },
        500: { description: "Internal Server Error" },
    },
    permission: "edit.ico.settings",
};
exports.default = async (data) => {
    const { user, body } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    const settings = await db_1.models.icoPlatformSettings.create(body);
    return { message: "Platform settings created successfully.", settings };
};
