"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get Token Type Configurations",
    description: "Retrieves all token type configurations for ICO admin.",
    operationId: "getTokenTypes",
    tags: ["ICO", "Admin", "TokenTypes"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Token type configurations retrieved successfully.",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "object" } },
                },
            },
        },
        401: { description: "Unauthorized – Admin privileges required." },
        500: { description: "Internal Server Error" },
    },
    permission: "view.ico.settings",
};
exports.default = async (data) => {
    const { user, query } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({
            statusCode: 401,
            message: "Unauthorized: Admin privileges required.",
        });
    }
    const enabledOnly = (query === null || query === void 0 ? void 0 : query.status) === "true";
    const whereClause = enabledOnly ? { status: true } : {};
    const tokenTypes = await db_1.models.icoTokenType.findAll({ where: whereClause });
    return tokenTypes;
};
