"use strict";
// /server/api/admin/wallets/transactions/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const constants_1 = require("@b/utils/constants");
exports.metadata = {
    summary: "Lists ICO transactions with optional filters",
    operationId: "listIcoTransactions",
    tags: ["Admin", "Ico", "Transaction"],
    parameters: constants_1.crudParameters,
    responses: {
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Transactions"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "view.ico.transaction",
};
exports.default = async (data) => {
    const { user, query } = data;
    if (!user) {
        throw new Error("Unauthorized");
    }
    return (0, query_1.getFiltered)({
        model: db_1.models.icoTransaction,
        query: query,
        sortField: query.sortField || "createdAt",
        includeModels: [
            {
                model: db_1.models.icoTokenOffering,
                as: "offering",
                attributes: ["id", "name", "symbol", "tokenPrice", "targetAmount"],
            },
            {
                model: db_1.models.user,
                as: "user",
                attributes: ["id", "email", "firstName", "lastName", "avatar"],
            },
        ],
    });
};
