"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendIcoEmail = sendIcoEmail;
exports.sendIcoBuyerEmail = sendIcoBuyerEmail;
exports.sendIcoSellerEmail = sendIcoSellerEmail;
const emails_1 = require("@b/utils/emails");
async function sendIcoEmail(emailType, recipientEmail, replacements) {
    // Construct the email data
    const emailData = {
        TO: recipientEmail,
        ...replacements,
    };
    // Queue the email for sending
    await emails_1.emailQueue.add({ emailData, emailType });
}
async function sendIcoBuyerEmail(recipientEmail, replacements) {
    await sendIcoEmail("IcoInvestmentOccurredBuyer", recipientEmail, replacements);
}
async function sendIcoSellerEmail(recipientEmail, replacements) {
    await sendIcoEmail("IcoInvestmentOccurredSeller", recipientEmail, replacements);
}
