"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk updates the status of Mailwizard Templates",
    operationId: "bulkUpdateMailwizardTemplateStatus",
    tags: ["Admin", "Mailwizard Templates"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            description: "Array of Mailwizard Template IDs to update",
                            items: { type: "string" },
                        },
                        status: {
                            type: "string",
                            enum: ["ACTIVE", "INACTIVE", "ARCHIVED"],
                            description: "New status to apply to the Mailwizard Templates",
                        },
                    },
                    required: ["ids", "status"],
                },
            },
        },
    },
    responses: (0, query_1.updateRecordResponses)("Mailwizard Template"),
    requiresAuth: true,
    permission: "edit.mailwizard.template",
};
exports.default = async (data) => {
    const { body } = data;
    const { ids, status } = body;
    return (0, query_1.updateStatus)("mailwizardTemplate", ids, status);
};
