"use strict";
// backend/src/api/admin/p2p/disputes/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const constants_1 = require("@b/utils/constants");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Lists all p2p disputes with pagination and optional filtering",
    operationId: "listP2PDisputes",
    tags: ["Admin", "P2P", "Disputes"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "Paginated list of p2p disputes with detailed information",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            data: {
                                type: "array",
                                items: { type: "object" },
                            },
                            pagination: constants_1.paginationSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("p2p Disputes"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "view.p2p.dispute",
};
exports.default = async (data) => {
    const { query, user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    // You might adjust filtering logic as needed.
    return (0, query_1.getFiltered)({
        model: db_1.models.p2pDispute,
        query,
        sortField: query.sortField || "filedOn",
        where: {},
        includeModels: [
            {
                model: db_1.models.p2pTrade,
                as: "trade",
            },
            {
                model: db_1.models.user,
                as: "reportedBy",
                attributes: ["id", "firstName", "lastName", "email", "avatar"],
            },
            {
                model: db_1.models.user,
                as: "against",
                attributes: ["id", "firstName", "lastName", "email", "avatar"],
            },
        ],
    });
};
