"use strict";
// backend/src/api/admin/p2p/trades/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const constants_1 = require("@b/utils/constants");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Lists all p2p trades with pagination and optional filtering",
    operationId: "listP2PTrades",
    tags: ["Admin", "P2P", "Trades"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "Paginated list of p2p trades with detailed information",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            data: {
                                type: "array",
                                items: {
                                    type: "object",
                                    // You can document p2pTrade properties here if needed.
                                },
                            },
                            pagination: constants_1.paginationSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("p2p Trades"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "view.p2p.trade",
};
exports.default = async (data) => {
    const { query, user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    // Adjust filtering as needed.
    return (0, query_1.getFiltered)({
        model: db_1.models.p2pTrade,
        query,
        sortField: query.sortField || "createdAt",
        // Optionally, add filtering here. For example, to exclude trades if the admin
        // is part of the transaction, you could use an AND condition. For now, we'll list all trades.
        where: {},
        includeModels: [
            {
                model: db_1.models.user,
                as: "buyer",
                attributes: ["id", "firstName", "lastName", "email", "avatar"],
            },
            {
                model: db_1.models.user,
                as: "seller",
                attributes: ["id", "firstName", "lastName", "email", "avatar"],
            },
            {
                model: db_1.models.p2pDispute,
                as: "dispute",
                // You can specify attributes or leave as default.
            },
        ],
    });
};
