"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk deletes Payment Intents by IDs",
    operationId: "bulkDeletePaymentIntents",
    tags: ["Admin", "Payment"],
    parameters: (0, query_1.commonBulkDeleteParams)("Payment Intents"),
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            items: { type: "string" },
                            description: "Array of Payment Intent IDs to delete",
                        },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: (0, query_1.commonBulkDeleteResponses)("Payment Intents"),
    requiresAuth: true,
    permission: "delete.payment.intent",
};
exports.default = async (data) => {
    const { body, query } = data;
    const { ids } = body;
    return (0, query_1.handleBulkDelete)({
        model: "paymentIntent",
        ids,
        query,
    });
};
