"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Stores a new Payment Intent",
    operationId: "storePaymentIntent",
    tags: ["Admin", "Payment"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: utils_1.paymentIntentUpdateSchema,
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.paymentIntentStoreSchema, "Payment Intent"),
    requiresAuth: true,
    permission: "create.payment.intent",
};
exports.default = async (data) => {
    const { body } = data;
    const { userId, walletId, amount, currency, tax, discount, status, ipnUrl, successUrl, failUrl, } = body;
    // Validate associated User
    const user = await db_1.models.user.findOne({ where: { id: userId } });
    if (!user)
        throw new Error("User not found");
    // Validate associated Wallet
    const wallet = await db_1.models.wallet.findOne({ where: { id: walletId } });
    if (!wallet)
        throw new Error("Wallet not found");
    // Store the Payment Intent record
    return await (0, query_1.storeRecord)({
        model: "paymentIntent",
        data: {
            userId,
            walletId,
            amount,
            currency,
            tax,
            discount,
            status,
            ipnUrl,
            successUrl,
            failUrl,
        },
    });
};
