"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paymentIntentProductStoreSchema = exports.paymentIntentProductSchema = exports.paymentIntentStoreSchema = exports.paymentIntentUpdateSchema = exports.paymentIntentSchema = void 0;
const schema_1 = require("@b/utils/schema");
// Payment Intent Schemas
const id = (0, schema_1.baseStringSchema)("ID of the Payment Intent");
const userId = (0, schema_1.baseStringSchema)("ID of the user associated with the payment intent");
const walletId = (0, schema_1.baseStringSchema)("ID of the wallet associated with the payment intent");
const amount = (0, schema_1.baseNumberSchema)("Amount of the payment intent");
const currency = (0, schema_1.baseStringSchema)("Currency used in the payment intent");
const tax = (0, schema_1.baseNumberSchema)("Tax amount of the payment intent");
const discount = (0, schema_1.baseNumberSchema)("Discount applied to the payment intent");
const status = {
    type: "string",
    enum: ["PENDING", "COMPLETED", "FAILED", "EXPIRED"],
    description: "Status of the payment intent",
};
const ipnUrl = (0, schema_1.baseStringSchema)("IPN URL for asynchronous payment notifications");
const apiKey = (0, schema_1.baseStringSchema)("API Key used for authentication");
const successUrl = (0, schema_1.baseStringSchema)("URL to redirect upon successful payment");
const failUrl = (0, schema_1.baseStringSchema)("URL to redirect upon failed payment");
const createdAt = (0, schema_1.baseDateTimeSchema)("Creation date of the payment intent");
const updatedAt = (0, schema_1.baseDateTimeSchema)("Last update date of the payment intent");
exports.paymentIntentSchema = {
    id,
    userId,
    walletId,
    amount,
    currency,
    tax,
    discount,
    status,
    ipnUrl,
    apiKey,
    successUrl,
    failUrl,
    createdAt,
    updatedAt,
};
exports.paymentIntentUpdateSchema = {
    type: "object",
    properties: {
        amount,
        tax,
        discount,
        status,
    },
    required: ["amount", "status"],
};
exports.paymentIntentStoreSchema = {
    type: "object",
    properties: {
        userId,
        walletId,
        amount,
        currency,
        tax,
        discount,
        status,
        ipnUrl,
        apiKey,
        successUrl,
        failUrl,
    },
    required: ["amount", "currency", "status", "ipnUrl", "successUrl", "failUrl"],
};
// Payment Intent Product Schemas
const productId = (0, schema_1.baseStringSchema)("ID of the Payment Intent Product");
const paymentIntentId = (0, schema_1.baseStringSchema)("ID of the Payment Intent associated with the product");
const name = (0, schema_1.baseStringSchema)("Name of the product");
const quantity = (0, schema_1.baseNumberSchema)("Quantity of the product");
const price = (0, schema_1.baseNumberSchema)("Price of the product");
const image = (0, schema_1.baseStringSchema)("Image URL of the product");
exports.paymentIntentProductSchema = {
    productId,
    paymentIntentId,
    name,
    quantity,
    price,
    currency,
    image,
};
exports.paymentIntentProductStoreSchema = {
    type: "object",
    properties: {
        name,
        quantity,
        price,
        currency,
        image,
    },
    required: ["name", "quantity", "price", "currency"],
};
