"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TonDeposits = void 0;
const safe_imports_1 = require("@b/utils/safe-imports");
class TonDeposits {
    constructor(options) {
        this.wallet = options.wallet;
        this.chain = options.chain;
        this.address = options.address;
    }
    async watchDeposits() {
        const TonService = await (0, safe_imports_1.getTonService)();
        if (!TonService) {
            throw new Error("TON service not available");
        }
        const tonService = await TonService.getInstance();
        await tonService.monitorTonDeposits(this.wallet, this.address);
    }
}
exports.TonDeposits = TonDeposits;
