"use strict";
// /server/api/exchange/orders/index.get.ts
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
const error_1 = require("@b/utils/error");
const queries_1 = require("@b/api/(ext)/ecosystem/utils/scylla/queries");
exports.metadata = {
    summary: "List Orders",
    operationId: "listOrders",
    tags: ["Exchange", "Orders"],
    description: "Retrieves a list of orders for the authenticated user.",
    parameters: [
        {
            name: "type",
            in: "query",
            description: "Type of order to retrieve.",
            schema: { type: "string" },
        },
        {
            name: "symbol",
            in: "query",
            description: "Symbol of the order to retrieve.",
            schema: { type: "string" },
        },
    ],
    responses: {
        200: {
            description: "A list of orders",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: utils_1.baseOrderSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Order"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw new Error("Unauthorized");
    const { currency, pair, type } = data.query;
    console.log(`[Ecosystem Orders] Fetching orders for user ${user.id}, type: ${type}, currency: ${currency}, pair: ${pair}`);
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    // If currency and pair are not provided, get all orders for the user
    if (!currency || !pair) {
        console.log(`[Ecosystem Orders] No currency/pair provided, fetching all orders for user ${user.id}`);
        const { getOrdersByUserId } = await Promise.resolve().then(() => __importStar(require("@b/api/(ext)/ecosystem/utils/scylla/queries")));
        try {
            const orders = await getOrdersByUserId(user.id);
            console.log(`[Ecosystem Orders] Retrieved ${orders.length} total orders from database`);
            // Filter by status (OPEN or not OPEN)
            const filteredOrders = orders.filter((order) => type === "OPEN" ? order.status === "OPEN" : order.status !== "OPEN");
            console.log(`[Ecosystem Orders] Filtered to ${filteredOrders.length} orders with status: ${type === "OPEN" ? "OPEN" : "NOT OPEN"}`);
            if (filteredOrders.length > 0) {
                console.log(`[Ecosystem Orders] Sample order:`, JSON.stringify(filteredOrders[0], (key, value) => typeof value === 'bigint' ? value.toString() : value));
            }
            // Convert bigint fields to numbers
            const result = filteredOrders.map((order) => {
                const { fromBigInt } = require("@b/api/(ext)/ecosystem/utils/blockchain");
                return {
                    ...order,
                    amount: fromBigInt(order.amount),
                    price: fromBigInt(order.price),
                    cost: fromBigInt(order.cost),
                    fee: fromBigInt(order.fee),
                    filled: fromBigInt(order.filled),
                    remaining: fromBigInt(order.remaining),
                };
            });
            console.log(`[Ecosystem Orders] Returning ${result.length} orders`);
            return result;
        }
        catch (error) {
            console.error(`[Ecosystem Orders] Error fetching orders:`, error);
            throw error;
        }
    }
    console.log(`[Ecosystem Orders] Fetching orders for specific symbol: ${currency}/${pair}`);
    const result = await (0, queries_1.getOrders)(user.id, `${currency}/${pair}`, type === "OPEN");
    console.log(`[Ecosystem Orders] Retrieved ${result.length} orders for symbol ${currency}/${pair}`);
    return result;
};
