"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
const sequelize_1 = require("sequelize");
exports.metadata = {
    summary: "Get FAQ Categories",
    description: "Retrieves distinct FAQ categories.",
    operationId: "getFAQCategories",
    tags: ["FAQ", "User"],
    responses: {
        200: {
            description: "Categories retrieved successfully",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "string" } },
                },
            },
        },
        401: { description: "Unauthorized" },
        500: { description: "Internal Server Error" },
    },
};
exports.default = async (data) => {
    try {
        // Use Sequelize's DISTINCT function to extract unique categories
        const categories = await db_1.models.faq.findAll({
            where: { status: true },
            attributes: [[(0, sequelize_1.fn)("DISTINCT", (0, sequelize_1.col)("category")), "category"]],
            raw: true,
        });
        // Map the results to a plain array of strings.
        const result = categories.map((item) => item.category);
        return result;
    }
    catch (error) {
        console.error("Error fetching FAQ categories:", error);
        throw (0, error_1.createError)({
            statusCode: 500,
            message: error instanceof Error
                ? error.message
                : "Failed to fetch FAQ categories",
        });
    }
};
