"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const error_1 = require("@b/utils/error");
const query_1 = require("@b/utils/query");
const order_1 = require("@b/api/(ext)/futures/utils/queries/order");
exports.metadata = {
    summary: "Cancel all futures orders",
    description: "Cancels all open futures orders for the authenticated user.",
    operationId: "cancelAllFuturesOrders",
    tags: ["Futures", "Orders"],
    responses: (0, query_1.createRecordResponses)("Orders cancelled"),
    requiresAuth: true,
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    try {
        const result = await (0, order_1.cancelAllOrdersByUserId)(user.id);
        return {
            message: "All futures orders cancelled successfully",
            cancelledCount: result.cancelledCount || 0,
        };
    }
    catch (error) {
        console.error("Error cancelling all futures orders:", error);
        throw (0, error_1.createError)({
            statusCode: 500,
            message: `Failed to cancel all futures orders: ${error.message}`,
        });
    }
};
