"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Get Active Blockchain Configurations",
    description: "Retrieves all active blockchain configurations for users.",
    operationId: "getActiveBlockchainConfigs",
    tags: ["ICO", "Blockchain"],
    responses: {
        200: {
            description: "Active blockchain configurations retrieved successfully.",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "object" } },
                },
            },
        },
        500: { description: "Internal Server Error" },
    },
};
exports.default = async (data) => {
    const activeBlockchains = await db_1.models.icoBlockchain.findAll({
        where: { status: true },
    });
    return activeBlockchains;
};
