"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const error_1 = require("@b/utils/error");
exports.metadata = {
    summary: "Get Launch Plans",
    description: "Retrieves all launch plans for ICO admin.",
    operationId: "getLaunchPlans",
    tags: ["ICO", "Admin", "LaunchPlans"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Launch plans retrieved successfully.",
            content: {
                "application/json": {
                    schema: { type: "array", items: { type: "object" } },
                },
            },
        },
        401: { description: "Unauthorized – Admin privileges required." },
        500: { description: "Internal Server Error" },
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({ statusCode: 401, message: "Unauthorized" });
    }
    // Return launch plans ordered by sortOrder
    const launchPlans = await db_1.models.icoLaunchPlan.findAll({
        order: [["sortOrder", "ASC"]],
    });
    return launchPlans;
};
