"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const constants_1 = require("@b/utils/constants");
const utils_1 = require("../../../finance/transaction/utils");
exports.metadata = {
    summary: "Lists ICO transactions with optional filters",
    operationId: "listIcoTransactions",
    tags: ["User", "Ico", "Transaction"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "Paginated list of ICO transactions retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            data: {
                                type: "array",
                                items: {
                                    type: "object",
                                    properties: utils_1.baseTransactionSchema,
                                },
                            },
                            pagination: constants_1.paginationSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Transactions"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "access.transaction",
};
exports.default = async (data) => {
    const { user, query } = data;
    if (!user) {
        throw new Error("Unauthorized");
    }
    return (0, query_1.getFiltered)({
        model: db_1.models.icoTransaction,
        where: { userId: user.id },
        query,
        sortField: query.sortField || "createdAt",
        includeModels: [
            {
                model: db_1.models.icoTokenOffering,
                as: "offering",
                attributes: ["id", "name", "symbol", "tokenPrice", "targetAmount"],
            },
        ],
    });
};
