"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Get P2P Trading Activity",
    description: "Retrieves recent trading activity logs for the authenticated user.",
    operationId: "getP2PTradingActivity",
    tags: ["P2P", "Dashboard"],
    responses: {
        200: { description: "Trading activity retrieved successfully." },
        401: query_1.unauthorizedResponse,
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw new Error("Unauthorized");
    try {
        const activity = await db_1.models.p2pActivityLog.findAll({
            where: { userId: user.id },
            order: [["createdAt", "DESC"]],
            limit: 10,
            raw: true,
        });
        return activity;
    }
    catch (err) {
        throw new Error("Internal Server Error: " + err.message);
    }
};
