"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const sequelize_1 = require("sequelize");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Get P2P Portfolio Data",
    description: "Retrieves the portfolio summary for the authenticated user.",
    operationId: "getP2PPortfolioData",
    tags: ["P2P", "Dashboard"],
    responses: {
        200: { description: "Portfolio data retrieved successfully." },
        401: query_1.unauthorizedResponse,
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id))
        throw new Error("Unauthorized");
    try {
        const portfolio = await db_1.models.p2pTrade.findOne({
            attributes: [
                [
                    db_1.sequelize.fn("SUM", db_1.sequelize.col("total")),
                    "totalValue",
                ],
            ],
            where: {
                status: "COMPLETED",
                [sequelize_1.Op.or]: [{ buyerId: user.id }, { sellerId: user.id }],
            },
            raw: true,
        });
        return portfolio;
    }
    catch (err) {
        throw new Error("Internal Server Error: " + err.message);
    }
};
