"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Get P2P Market Highlights",
    description: "Retrieves highlighted market data (for example, top active offers).",
    operationId: "getP2PMarketHighlights",
    tags: ["P2P", "Market"],
    responses: {
        200: { description: "P2P market highlights retrieved successfully." },
        401: query_1.unauthorizedResponse,
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    try {
        // Example: get the five newest active offers
        const highlights = await db_1.models.p2pOffer.findAll({
            where: { status: "active" },
            order: [["createdAt", "DESC"]],
            limit: 5,
        });
        return highlights;
    }
    catch (err) {
        throw new Error("Internal Server Error: " + err.message);
    }
};
