"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const sequelize_1 = require("sequelize");
exports.metadata = {
    summary: "Get P2P Market Stats",
    description: "Retrieves aggregated market statistics from P2P trades.",
    operationId: "getP2PMarketStats",
    tags: ["P2P", "Market"],
    responses: {
        200: { description: "Market stats retrieved successfully." },
        401: query_1.unauthorizedResponse,
        500: query_1.serverErrorResponse,
    },
    requiresAuth: false,
};
exports.default = async () => {
    try {
        const stats = await db_1.models.p2pTrade.findOne({
            attributes: [
                [(0, sequelize_1.fn)("COUNT", (0, sequelize_1.literal)("*")), "totalTrades"],
                [(0, sequelize_1.fn)("SUM", (0, sequelize_1.literal)("total")), "totalVolume"],
                [(0, sequelize_1.fn)("AVG", (0, sequelize_1.literal)("total")), "avgTradeSize"],
            ],
            raw: true,
        });
        return stats;
    }
    catch (err) {
        throw new Error("Internal Server Error: " + err.message);
    }
};
