"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
const sequelize_1 = require("sequelize");
exports.metadata = {
    summary: "Get Top Cryptocurrencies in P2P",
    description: "Retrieves the top cryptocurrencies based on trade volume aggregations.",
    operationId: "getP2PTopCryptos",
    tags: ["P2P", "Market"],
    responses: {
        200: { description: "Top cryptocurrencies retrieved successfully." },
        401: query_1.unauthorizedResponse,
        500: query_1.serverErrorResponse,
    },
    requiresAuth: false,
};
exports.default = async () => {
    try {
        const topCryptos = await db_1.models.p2pTrade.findAll({
            attributes: ["currency", [(0, sequelize_1.fn)("SUM", (0, sequelize_1.literal)("total")), "totalVolume"]],
            group: ["currency"],
            order: [[db_1.sequelize.literal("totalVolume"), "DESC"]],
            limit: 5,
            raw: true,
        });
        return topCryptos;
    }
    catch (err) {
        throw new Error("Internal Server Error: " + err.message);
    }
};
