"use strict";
// /server/api/pages/delete.del.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk deletes pages by IDs",
    operationId: "bulkDeletePages",
    tags: ["Admin", "Content", "Page"],
    parameters: (0, query_1.commonBulkDeleteParams)("Pages"),
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            items: { type: "string" },
                            description: "Array of page IDs to delete",
                        },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: (0, query_1.commonBulkDeleteResponses)("Pages"),
    requiresAuth: true,
    permission: "delete.page",
};
exports.default = async (data) => {
    const { body, query } = data;
    const { ids } = body;
    return (0, query_1.handleBulkDelete)({
        model: "page",
        ids,
        query,
    });
};
