"use strict";
// /api/admin/pages/store.post.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
const db_1 = require("@b/db");
exports.metadata = {
    summary: "Stores or updates a CMS page",
    operationId: "storePage",
    tags: ["Admin", "Content", "Page"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: utils_1.basePageSchema,
                    required: ["title", "content", "slug", "status"],
                },
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.pageStoreSchema, "Page"),
    requiresAuth: true,
    permission: "create.page",
};
exports.default = async (data) => {
    const { body, user } = data;
    const { title, content, description, image, slug, status, order, isHome, isBuilderPage, template, category, seoTitle, seoDescription, seoKeywords, ogImage, ogTitle, ogDescription, settings, customCss, customJs, } = body;
    // Optional: validate settings JSON if present
    if (settings) {
        try {
            JSON.parse(settings);
        }
        catch (err) {
            throw new Error("settings: Must be valid JSON");
        }
    }
    const page = await db_1.models.page.create({
        title,
        content,
        description,
        image,
        slug,
        status,
        order,
        isHome,
        isBuilderPage,
        template,
        category,
        seoTitle,
        seoDescription,
        seoKeywords,
        ogImage,
        ogTitle,
        ogDescription,
        settings,
        customCss,
        customJs,
        lastModifiedBy: (user === null || user === void 0 ? void 0 : user.id) || null, // Track who created the page
    });
    return page;
};
