"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "Stores a new Binary Duration",
    operationId: "storeBinaryDuration",
    tags: ["Admin", "Binary Durations"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: utils_1.BinaryDurationUpdateSchema,
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.BinaryDurationStoreSchema, "Binary Duration"),
    requiresAuth: true,
    permission: "create.binary.duration",
};
exports.default = async (data) => {
    const { body } = data;
    const { duration, profitPercentage, status } = body;
    return await (0, query_1.storeRecord)({
        model: "binaryDuration",
        data: {
            duration,
            profitPercentage,
            status: status !== undefined ? status : true,
        },
    });
};
