"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinaryDurationUpdateSchema = exports.BinaryDurationStoreSchema = exports.binaryDurationSchema = void 0;
const schema_1 = require("@b/utils/schema");
const id = (0, schema_1.baseStringSchema)("ID of the binary duration");
const duration = (0, schema_1.baseNumberSchema)("Duration in minutes for binary option expiry");
const profitPercentage = (0, schema_1.baseNumberSchema)("Profit percentage offered for this duration");
const status = (0, schema_1.baseBooleanSchema)("Whether this duration is active and available for trading");
exports.binaryDurationSchema = {
    id,
    duration,
    profitPercentage,
    status,
};
exports.BinaryDurationStoreSchema = {
    type: "object",
    properties: {
        duration,
        profitPercentage,
        status,
    },
    required: ["duration", "profitPercentage", "status"],
};
exports.BinaryDurationUpdateSchema = {
    type: "object",
    properties: {
        duration,
        profitPercentage,
        status,
    },
    required: ["duration", "profitPercentage"],
};
