"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "Stores a new Binary Market",
    operationId: "storeBinaryMarket",
    tags: ["Admin", "Binary Markets"],
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: utils_1.BinaryMarketUpdateSchema,
            },
        },
    },
    responses: (0, query_1.storeRecordResponses)(utils_1.BinaryMarketStoreSchema, "Binary Market"),
    requiresAuth: true,
    permission: "create.binary.market",
};
exports.default = async (data) => {
    const { body } = data;
    const { currency, pair, isTrending, isHot, status } = body;
    return await (0, query_1.storeRecord)({
        model: "binaryMarket",
        data: {
            currency,
            pair,
            isTrending: isTrending !== undefined ? isTrending : false,
            isHot: isHot !== undefined ? isHot : false,
            status: status !== undefined ? status : true,
        },
    });
};
