"use strict";
// /server/api/investment/investments/delete.del.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk deletes investments by IDs",
    operationId: "bulkDeleteInvestments",
    tags: ["Admin", "General", "Investments"],
    parameters: (0, query_1.commonBulkDeleteParams)("Investments"),
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            items: { type: "string" },
                            description: "Array of investment IDs to delete",
                        },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: (0, query_1.commonBulkDeleteResponses)("Investments"),
    requiresAuth: true,
    permission: "delete.investment",
};
exports.default = async (data) => {
    const { body, query } = data;
    const { ids } = body;
    return (0, query_1.handleBulkDelete)({
        model: "investment",
        ids,
        query,
    });
};
