"use strict";
// /server/api/blog/author/post.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Retrieve author with his posts",
    description: "This endpoint retrieves the author profile associated with a given user id along with the posts linked to that profile.",
    operationId: "getAuthorWithPosts",
    tags: ["Content", "Author"],
    requiresAuth: true,
    responses: {
        200: {
            description: "Author and posts retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            author: {
                                type: "object", // Define your author schema here if needed
                            },
                            posts: {
                                type: "array",
                                items: {
                                    type: "object", // Define your post schema here if needed
                                },
                            },
                        },
                    },
                },
            },
        },
        404: (0, query_1.notFoundMetadataResponse)("Author"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const { query, user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw new Error("Missing userId parameter");
    }
    // Find the author by matching on userId and include associated posts
    const author = await db_1.models.author.findOne({
        where: { userId: user.id },
        include: [
            {
                model: db_1.models.post,
                as: "posts",
                include: [
                    {
                        model: db_1.models.category,
                        as: "category",
                    },
                ],
            },
        ],
    });
    if (!author) {
        // If no author is found for the given user id, throw an error (to be handled appropriately)
        throw new Error("Author not found");
    }
    return author;
};
