"use strict";
// /server/api/exchange/binary/duration/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "List Available Binary Durations",
    operationId: "listBinaryDurations",
    tags: ["Exchange", "Binary"],
    description: "Retrieves a list of available durations for binary options.",
    responses: {
        200: {
            description: "A list of binary durations",
            content: {
                "application/json": {
                    schema: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {}, // Define duration properties schema as needed.
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Binary Duration"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const durations = await db_1.models.binaryDuration.findAll({
        order: [["duration", "ASC"]], // Adjust order/column name as needed.
    });
    return durations;
};
